/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import java.io.File;
import java.util.StringTokenizer;

public class NativeProcessParameters {
    String[] cmdarray;
    String[] envp;
    String dir;
    int fdCount;
    int[] parentFds;
    int[] childFds;
    int processGroupId = -1;
    boolean orphan;

    public NativeProcessParameters(String command) {
        this(command, null);
    }

    public NativeProcessParameters(String cmd, String[] envp) {
        this(cmd, envp, null);
    }

    public NativeProcessParameters(String command, String[] envp, File dir) {
        this.envp = envp;
        if (dir != null) {
            this.dir = dir.getPath();
        }
        StringTokenizer tokenizer = new StringTokenizer(command);
        int count = tokenizer.countTokens();
        this.cmdarray = new String[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            this.cmdarray[i] = tokenizer.nextToken();
            ++i;
        }
    }

    public NativeProcessParameters(String[] cmdarray) {
        this(cmdarray, null, null);
    }

    public NativeProcessParameters(String[] cmdarray, String[] envp) {
        this(cmdarray, envp, null);
    }

    public NativeProcessParameters(String[] cmdarray, String[] envp, File dir) {
        this.cmdarray = cmdarray;
        this.envp = envp;
        if (dir != null) {
            this.dir = dir.getPath();
        }
    }

    public synchronized void addInheritedFd(int parentsFd, int childsFd) {
        if (this.fdCount == 0) {
            this.parentFds = new int[5];
            this.childFds = new int[5];
        }
        if (this.fdCount == this.parentFds.length) {
            int[] oldFds = this.parentFds;
            this.parentFds = new int[oldFds.length + 5];
            System.arraycopy(oldFds, 0, this.parentFds, 0, oldFds.length);
            oldFds = this.childFds;
            this.childFds = new int[oldFds.length + 5];
            System.arraycopy(oldFds, 0, this.childFds, 0, oldFds.length);
        }
        this.parentFds[this.fdCount] = parentsFd;
        this.childFds[this.fdCount++] = childsFd;
    }

    public void closeInheritedFd(int childsFd) {
        this.addInheritedFd(-1, childsFd);
    }

    public void putInProcessGroup(int processGroupId) {
        this.processGroupId = processGroupId;
    }

    public void putInNewProcessGroup() {
        this.processGroupId = 0;
    }

    public void setOrphan(boolean orphan) {
        this.orphan = orphan;
    }

    public boolean isOrphan() {
        return this.orphan;
    }
}

